7                     '*  -      &*                          ,    ,    ,    ,    ,   ,) J  ,s    ,s    ,s    ,s 
  ,} 
  ,    , X  , x  ,s    -W    -w   - *  -    ,                                                                        digital image special fx PART XIII: Creating Quick and Easy Seamless Texture Maps

by William Frawley


	Last time we discussed various methods for creating your own background images and textures. This month, let's take that subject a bit further by examining a quick and relatively easy technique for converting those appropriate images into seamless textures suitable for tiling onto 3D objects. For those of you unfamiliar with 3D animation, perhaps a brief exposition is in order.

Seamless Defined
	A seamless image is one whose sides are perfectly congruent with each other. In other words, if the left edge of the image is abutted to the right edge of this same image, there will be no visible "seam" between them. The image's content will flow undetected into itself. This same concept applies to both the top and bottom edges as well. A completely seamless image then allows itself to be tiled, or laid side-to-side and/or top-to-bottom, thus forming one cohesive pattern.

Usage
	So why are seamless images so important? Well, maybe convenient is more accurate, but their significance is nowhere more important than in the world of 3D texture mapping. With a properly constructed seamless texture, one small image of a chain-link, for example, when mapped repeatedly onto a plane will produce a whole chain-link fence. Get the picture (Figure 1)? With that in mind, our task here then will be to employ some 2D image processing to supplement 3D applications.

Various Seamless Techniques
	There appear to be several methods for creating/converting images into seamless textures. We'll focus on a technique that seems best suited for rather homogeneous, organic-looking images like gases, marble, terrains, rocks and other textures devoid of artificial features. With this method, it is important that there be no distinguishing features present in the base texture because they will noticeably repeat themselves over the course of multiple tiles, thus destroying the subtle effect. However, this rule usually applies to organic textures with no individually recognizable elements, unlike bricks, fences, stones, etc. where other methods described below are most likely used to create these types of seamless textures. Substances like wood fall on the borderline with these methods, depending on how distinct the grain patterns are. Before I describe our quick and easy process however, let me briefly mention those other possible techniques.
	One foolproof method for creating seamless images uses a computer algorithm to do the work mathematically. Such processes might be found in some of the Photoshop plug-in filter technology. No seams, no sweat. Another method suitable for more regular patterned motifs like the chain-link fence or brick examples alluded to earlier involves cutting off a strip in just the right location from one side, flipping it 180 degrees and enjoining it to the opposite edge in such a way so that the pattern repeats naturally. Manual touch-ups with a paint program are usually necessary for tweeking the edges together correctly. This method is similar to the one we'll be employing.
	Remember, the method we'll be covering is quick and easy, but not entirely foolproof for some textures. It is best used to smooth the hard seams for a tiled image. Unlike a true seamless image, which are best designed for obvious repeating patterns like bricks or fences, this technique produces a quick hack by overlapping the edges with an alpha channel modulating the composite process. But, enough with the generalities, here are the specifics.

Which Software Will Work?
	Any image processing program that can utilize an Alpha channel for compositing or has a transparency gradient mode for brushes will work. This includes programs like The Art Department Professional, ImageMaster, OpalPaint, ImageFX and, of course, Photoshop (if you're using a Mac emulator). The process described below will use the Alpha channel to composite between images, but can easily be adapted to using brushes with an Alpha or transparency gradient. Utilizing a brush simply substitutes for cropping a portion of an image and saving that piece for later compositing. The following tutorial will describe how to process one edge of an image only -- the side. The same technique can then be applied to the top/bottom edge.

The How-To Part
	First, scan or digitize some kind of texture, or use an image obtained by some other means that isn't already seamless. Load it into your desired image processor. For the record, I'm using ADPro. Note and record the image's dimensions W and H. If you have a swap or temporary buffer, Save the image to it. This will just make things a little easier when reloading later.
	Next, crop a strip off of the left side of the image that is about 10-20% of the width of the entire image but exactly the same height. In other words, this new strip will have dimensions of X=W*.1 and Y=H. Save this strip to RAM: or your hard drive as "Strip."
	Now create a strip with the same dimensions (X and Y) as the last strip with a horizontal gradient of black to white running from left to right. ADPro's Backdrop loader works quite effectively. This image will serve as our Alpha channel mask between the original image and Strip. Save this image as "Strip.alpha." Depending on which program you're using, you may need to convert this image to 8-bit greyscale for use as an Alpha channel. As of ADPro 2.3 or later, this is not necessary when compositing with Alpha images. Refer to Figure 2 if you're having problems conceptualizing this process thus far.
	Again, reload the original image, from the swap buffer if applicable, but this time crop the area exclusive of the one in which you cropped Strip from. The dimensions should be W'=W-X and H'=H, and an X Offset of X. This is our new base image.
	For the final step, with the NewBase image still residing in the work buffer, composite Strip onto this image using Strip.alpha as the Alpha channel between the two. Remember to use the proper X Offset (W'-X) for both Strip and Strip.alpha so that their right edge aligns with NewBase's right edge. The result shows that the image's new right edge gradually fades into its old left edge, thus forming a perfect seam with its new left edge. The essential chore is handled by the Alpha channel controlling the mix from left to right between NewBase and Strip. Render or display your results.
	Don't sweat if you're hard pressed to recognize the difference in its current state. Wrap it and the original onto a sphere or cylinder alongside each other in your favorite 3D software and then render to better see the difference. You may have to rotate the sphere's heading 90 or 180 degrees to bring the seams into camera view, depending on where your software positions the seam when texture mapping. Check out Figures 3a-3c to see how a scan of Jupiter became seamless along the side.
	For complete seamlessness, repeat the process above with this new image, remembering that all the previous dimensions will be different and the strip will be across the top, not the side. In order to see the results of complete seamlessness once both the top and sides have been processed, map (tile) the image onto a plane so that four images fit perfectly across the face like a checkerboard (Figure 4c).

The Macro
	For those of you using ADPro, I've included yet another ARexx macro that will create a seamless image automatically in less time than it takes to blow your nose. Assuming you have enough RAM:, a typical image takes approximately 10 seconds. Ahhhh, the power of ARexx!
	First, you'll be prompted to choose whether to process the side, the top or both. Usually, if you're only going to be wrapping the image spherically or cylindrically like a planetary or soda can texture, creating a seamless side is sufficient. However, if you plan on mapping the texture to a plane like a tiled floor, you'll want to do both edges. The "Top Only" choice is included for completeness. I haven't yet found a need to tile textures in the vertical direction exclusively.
	Next, you'll be asked to what degree is the texture homogeneous in its pattern or motif. As mentioned earlier, if the image contains regions of distinct patterns, the strip to be composited will have to be cropped larger in order to increase the distance it takes to blend it with the underlying region of the base image. In this case, you'd want to select "Chaotic." Otherwise, if you can get by with "Homogeneous," more of your original texture will remain intact.
	As you can see from the _SeamlessMap.adpro macro, in order to create the Alpha channel strip, I've used the BackDrop loader in "Color" mode. Specifying "Grey" fails to use the specified color or grey values and direction information properly. I assume this is a bug, but I haven't yet contacted Elastic Reality about the matter yet. Anyhow, just specify a color backdrop and use the appropriate greyscale values and it'll work fine. If you need to convert the Alpha mask to an 8-bit greyscale for earlier versions to composite, add the line:


	Operator "Color_To_Grey"

right after the BackDrop loader line.

Bye
	Well, that about wraps (no pun intended) it up for this time. Hopefully, if you ever need a seamless texture in a pinch, you'll keep this quick method in mind -- even quicker with the macro. If you despise typing in these macros by hand, feel free to write to me in care of this magazine for details on getting this months and any previous macros listed in this column by mail or modem. Please allow about 30 days for your letter to reach me from Amazing Computing. I'm still wondering why it takes that long myself. Until next time, hope this stuff was useful if not mildly interesting. Chow!
T:    % T     WN    " Z+    # `    $ b=      o"     w     w     |     J     s               \    	     
               '*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            R  S  f  g  h                    
  
7              s  z                     "p  $  $  $  $  $  $  $  $  '*                                                                                                                                                                               !     	!     
!     !     !     !     !     !     !     !     !     !  +        
               &*       3      $  &*   b             H          '*      '*       
       ! "                    3/30313233349394959697    H H    (FG(    H H    (    d       '                     @                         =/  R    @      H 
-:LaserWriter 
     (  (                                                                                         